/*
 * Decompiled with CFR 0.152.
 */
package com.zainjx.the_wild_update.custom.tree;

import com.mojang.serialization.Codec;
import com.zainjx.the_wild_update.custom.block.PropaguleBlock;
import com.zainjx.the_wild_update.registry.RegistryMangrove;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class MangroveTreeDecorator
extends TreeDecorator {
    public static final MangroveTreeDecorator INSTANCE = new MangroveTreeDecorator();
    public static final Codec<MangroveTreeDecorator> CODEC = Codec.unit(() -> INSTANCE);
    public static TreeDecoratorType<?> tdt = new TreeDecoratorType(CODEC);

    private static void placeVines(LevelSimulatedReader world, BlockPos pos, BooleanProperty facing, BiConsumer<BlockPos, BlockState> replacer) {
        MangroveTreeDecorator.m_161750_(replacer, (BlockPos)pos, (BooleanProperty)facing);
        pos = pos.m_7495_();
        for (int i = 4; Feature.m_65810_((LevelSimulatedReader)world, (BlockPos)pos) && i > 0; --i) {
            MangroveTreeDecorator.m_161750_(replacer, (BlockPos)pos, (BooleanProperty)facing);
            pos = pos.m_7495_();
        }
    }

    protected TreeDecoratorType<?> m_6663_() {
        return tdt;
    }

    public void m_142741_(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, Random random, List<BlockPos> logPositions, List<BlockPos> leavesPositions) {
        for (BlockPos logPosition : logPositions) {
            BlockPos targetPosition;
            if (world.m_7433_(logPosition.m_6625_(4), Predicate.isEqual(((Block)RegistryMangrove.MANGROVE_LOG.get()).m_49966_())) || world.m_7433_(logPosition.m_6625_(4), Predicate.isEqual(Blocks.f_50016_.m_49966_())) || !world.m_7433_(logPosition.m_6625_(3), Predicate.isEqual(((Block)RegistryMangrove.MANGROVE_LOG.get()).m_49966_())) || !world.m_7433_(logPosition.m_6625_(2), Predicate.isEqual(((Block)RegistryMangrove.MANGROVE_LOG.get()).m_49966_())) || !world.m_7433_(logPosition.m_7495_(), Predicate.isEqual(((Block)RegistryMangrove.MANGROVE_LOG.get()).m_49966_()))) continue;
            BlockPos currentPosition = targetPosition = logPosition.m_7495_().m_142126_();
            while (world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_50016_.m_49966_())) || world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_49990_.m_49966_())) || world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_50627_.m_49966_()))) {
                this.placeRootBlock(currentPosition, world, replacer);
                currentPosition = currentPosition.m_7495_();
            }
            BlockPos posXPos = currentPosition;
            currentPosition = targetPosition = logPosition.m_7495_().m_142125_();
            while (world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_50016_.m_49966_())) || world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_49990_.m_49966_())) || world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_50627_.m_49966_()))) {
                this.placeRootBlock(currentPosition, world, replacer);
                currentPosition = currentPosition.m_7495_();
            }
            BlockPos posXNeg = currentPosition;
            currentPosition = targetPosition = logPosition.m_7495_().m_142127_();
            while (world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_50016_.m_49966_())) || world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_49990_.m_49966_())) || world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_50627_.m_49966_()))) {
                this.placeRootBlock(currentPosition, world, replacer);
                currentPosition = currentPosition.m_7495_();
            }
            BlockPos posZPos = currentPosition;
            currentPosition = targetPosition = logPosition.m_7495_().m_142128_();
            while (world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_50016_.m_49966_())) || world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_49990_.m_49966_())) || world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_50627_.m_49966_()))) {
                this.placeRootBlock(currentPosition, world, replacer);
                currentPosition = currentPosition.m_7495_();
            }
            BlockPos posZNeg = currentPosition;
            if (posXPos.m_123342_() <= posXNeg.m_123342_() && posXPos.m_123342_() <= posZPos.m_123342_() && posXPos.m_123342_() <= posZNeg.m_123342_()) {
                targetPosition = posXPos;
            } else if (posXNeg.m_123342_() <= posXPos.m_123342_() && posXNeg.m_123342_() <= posZPos.m_123342_() && posXNeg.m_123342_() <= posZNeg.m_123342_()) {
                targetPosition = posXPos;
            } else if (posZPos.m_123342_() <= posXPos.m_123342_() && posZPos.m_123342_() <= posXNeg.m_123342_() && posZPos.m_123342_() <= posZNeg.m_123342_()) {
                targetPosition = posXPos;
            } else if (posZNeg.m_123342_() <= posXPos.m_123342_() && posZNeg.m_123342_() <= posXNeg.m_123342_() && posZNeg.m_123342_() <= posZPos.m_123342_()) {
                targetPosition = posXPos;
            }
            targetPosition = targetPosition.m_7494_();
            this.placeRootBottom(targetPosition, world, replacer);
        }
        for (BlockPos leavesPosition : leavesPositions) {
            BlockPos blockPos4;
            if ((world.m_7433_(leavesPosition.m_7495_(), Predicate.isEqual(Blocks.f_50016_.m_49966_())) || world.m_7433_(leavesPosition.m_7495_(), Predicate.isEqual(Blocks.f_49990_.m_49966_())) || world.m_7433_(leavesPosition.m_7495_(), Predicate.isEqual(Blocks.f_50627_.m_49966_()))) && Math.random() > 0.85) {
                if (world.m_7433_(leavesPosition.m_7495_(), Predicate.isEqual(Blocks.f_50016_.m_49966_())) || world.m_7433_(leavesPosition.m_7495_(), Predicate.isEqual(Blocks.f_50627_.m_49966_()))) {
                    replacer.accept(leavesPosition.m_7495_(), (BlockState)((Block)RegistryMangrove.MANGROVE_PROPAGULE.get()).m_49966_().m_61124_((Property)PropaguleBlock.HANGING, (Comparable)Boolean.valueOf(true)));
                } else if (world.m_7433_(leavesPosition.m_7495_(), Predicate.isEqual(Blocks.f_49990_.m_49966_()))) {
                    replacer.accept(leavesPosition.m_7495_(), ((Block)RegistryMangrove.MANGROVE_PROPAGULE.get()).m_49966_());
                }
            }
            if (random.nextInt(4) == 0 && Feature.m_65810_((LevelSimulatedReader)world, (BlockPos)(blockPos4 = leavesPosition.m_142125_()))) {
                MangroveTreeDecorator.placeVines(world, blockPos4, VineBlock.f_57835_, replacer);
            }
            if (random.nextInt(4) == 0 && Feature.m_65810_((LevelSimulatedReader)world, (BlockPos)(blockPos4 = leavesPosition.m_142126_()))) {
                MangroveTreeDecorator.placeVines(world, blockPos4, VineBlock.f_57837_, replacer);
            }
            if (random.nextInt(4) == 0 && Feature.m_65810_((LevelSimulatedReader)world, (BlockPos)(blockPos4 = leavesPosition.m_142127_()))) {
                MangroveTreeDecorator.placeVines(world, blockPos4, VineBlock.f_57836_, replacer);
            }
            if (random.nextInt(4) != 0 || !Feature.m_65810_((LevelSimulatedReader)world, (BlockPos)(blockPos4 = leavesPosition.m_142128_()))) continue;
            MangroveTreeDecorator.placeVines(world, blockPos4, VineBlock.f_57834_, replacer);
        }
    }

    private void placeRootBlock(BlockPos currentPosition, LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer) {
        if (world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_50016_.m_49966_())) || world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_50627_.m_49966_()))) {
            replacer.accept(currentPosition, ((Block)RegistryMangrove.MANGROVE_ROOTS.get()).m_49966_());
        } else if (world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_49990_.m_49966_())) || world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_50034_.m_49966_())) || world.m_7433_(currentPosition, Predicate.isEqual(Blocks.f_50359_.m_49966_()))) {
            replacer.accept(currentPosition, ((Block)RegistryMangrove.MANGROVE_ROOTS.get()).m_49966_());
        }
        if (world.m_7433_(currentPosition.m_7494_(), Predicate.isEqual(Blocks.f_50196_.m_49966_()))) {
            replacer.accept(currentPosition.m_7494_(), Blocks.f_50016_.m_49966_());
        }
    }

    private void placeRootBottom(BlockPos targetPosition, LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer) {
        BlockPos currentPosition = targetPosition;
        for (int i = 0; i < 6; ++i) {
            this.placeRootBlock(currentPosition, world, replacer);
            Random rand = new Random();
            int dir = rand.nextInt(4);
            if (dir == 0) {
                currentPosition = currentPosition.m_142126_();
            } else if (dir == 1) {
                currentPosition = currentPosition.m_142125_();
            } else if (dir == 2) {
                currentPosition = currentPosition.m_142127_();
            } else if (dir == 3) {
                currentPosition = currentPosition.m_142128_();
            }
            if (currentPosition.m_123314_((Vec3i)targetPosition, 3.0)) continue;
            currentPosition = targetPosition;
            --i;
        }
    }

    static {
        tdt.setRegistryName("mangrove_swamp_tree_decorator");
    }
}

